/** @file   GraphicContent.h
 * @brief   Declaration of GraphicContent class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:38 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_ENG2D_GRAPHICCONTENT_H
#define H_ENG2D_GRAPHICCONTENT_H




/** @class  GraphicContent
 * @brief
 * @author  Tomi Lamminsaari
 *
 */
class GraphicContent
{
public:

    ///
    /// Constants, datatypes and static methods
    /// =======================================


    ///
    /// Constructors, destructor and operators
    /// ======================================

    /** Default constructor.
     */
    GraphicContent();
    
    /** Destructor
     */
    virtual ~GraphicContent();

private:
  
    /** Copy constructor
     * @param   aAnother          Reference to another GraphicContent
     */
    GraphicContent( const GraphicContent& aAnother );

    /** An assignment operator
     * @param   aAnother          Reference to another GraphicContent
     * @return  Reference to this object.
     */
    GraphicContent& operator= ( const GraphicContent& aAnother );

public:

    ///
    /// Inherited methods
    /// =================


    ///
    /// New public methods
    /// ==================


    ///
    /// Getter methods
    /// ==============
    
    /** Returns the width of the graphic content.
     * @return  Width in pixels
     */
    int Width() const = 0;
    
    /** Returns the height of the graphic content.
     * @return  Height in pixels
     */
    int Height() const = 0;


protected:
    ///
    /// Protected interface
    /// ===================


protected:
    ///
    /// Data members
    /// ============

};


#endif
